// Desplazamiento suave para enlaces de navegación
document.querySelectorAll('a[href^="#"]').forEach(anchor => {
  anchor.addEventListener('click', function (e) {
    e.preventDefault();

    document.querySelector(this.getAttribute('href')).scrollIntoView({
      behavior: 'smooth'
    });
  });
});

// Botón de "Volver al inicio"
const backToTopButton = document.createElement('button');
backToTopButton.innerText = 'Volver al inicio';
backToTopButton.classList.add('back-to-top');
document.body.appendChild(backToTopButton);

backToTopButton.addEventListener('click', () => {
  window.scrollTo({
    top: 0,
    behavior: 'smooth'
  });
});

// Mostrar/ocultar el botón de "Volver al inicio"
window.addEventListener('scroll', () => {
  if (document.body.scrollTop > 200 || document.documentElement.scrollTop > 200) {
    backToTopButton.style.display = 'block';
  } else {
    backToTopButton.style.display = 'none';
  }
});

// Modal de inscripción
const modal = document.createElement('div');
modal.classList.add('modal');
modal.innerHTML = `
  <div class="modal-content">
    <span class="close-button">&times;</span>
    <h2>Inscripción</h2>
    <p>Para inscribirte en el curso, por favor completa el siguiente formulario:</p>
    <form id="registration-form">
      <input type="text" placeholder="Tu nombre" required />
      <input type="email" placeholder="Tu correo" required />
      <button type="submit">Enviar</button>
    </form>
  </div>
`;
document.body.appendChild(modal);

const openModalButtons = document.querySelectorAll('.open-modal');
const closeButton = document.querySelector('.close-button');

openModalButtons.forEach(button => {
  button.addEventListener('click', () => {
    modal.style.display = 'block';
  });
});

closeButton.addEventListener('click', () => {
  modal.style.display = 'none';
});

window.addEventListener('click', (event) => {
  if (event.target === modal) {
    modal.style.display = 'none';
  }
});

// Manejo del formulario de inscripción
document.getElementById('registration-form')?.addEventListener('submit', function (e) {
  e.preventDefault();
  alert('Gracias por inscribirte! Te contactaremos pronto.');
  modal.style.display = 'none';
});
