document.addEventListener("DOMContentLoaded", function() {
    // Animación al hacer scroll para secciones y elementos individuales
    // Ahora selecciona todos los elementos con la clase "animate-on-scroll"
    const animatedElements = document.querySelectorAll(".animate-on-scroll");

    const observerOptions = {
        root: null, // El viewport es el elemento raíz
        rootMargin: "0px",
        threshold: 0.1 // El 10% del elemento debe estar visible para activar la animación
    };

    const elementObserver = new IntersectionObserver((entries, observer) => {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                entry.target.classList.add("visible");
                observer.unobserve(entry.target); // Deja de observar una vez que el elemento es visible y animado
            }
        });
    }, observerOptions);

    animatedElements.forEach(element => {
        elementObserver.observe(element);
    });

    // Sticky Header (Cabecera Fija)
    const header = document.querySelector("header");
    // Obtenemos la sección hero para saber cuándo el header debe volverse sticky
    const heroSection = document.querySelector(".hero");
    let heroHeight = 0;

    // Aseguramos que heroSection exista antes de intentar obtener su altura
    if (heroSection) {
        heroHeight = heroSection.offsetHeight;
    }

    // Evento de scroll para el header
    window.addEventListener("scroll", () => {
        // El header se vuelve "scrolled" (fijo) cuando la posición de scroll
        // es mayor que la altura de la sección hero menos la altura del propio header
        if (window.scrollY > heroHeight - header.offsetHeight) {
            header.classList.add("scrolled");
        } else {
            header.classList.remove("scrolled");
        }
    });

    // Actualizar la altura de hero si la ventana cambia de tamaño
    window.addEventListener('resize', () => {
        if (heroSection) {
            heroHeight = heroSection.offsetHeight;
        }
    });

    // Opcional: Carrusel de testimonios básico (si no usas una librería)
    // Para un carrusel más avanzado, considera librerías como Swiper.js o Slick.js
    const testimonialSlider = document.querySelector(".testimonial-slider");
    if (testimonialSlider) {
        // Por ahora, solo se muestran los items estáticamente como los tienes.
        // Si quieres un slider interactivo aquí, esta parte necesitaría más código JS.
        // Por ejemplo, para añadir flechas de navegación, puntos de paginación,
        // y la lógica para cambiar los testimonios.
    }
});